// By EVOLVED
// www.evolved-software.com

//-------------
// un-tweaks
//-------------
   float4x4 ViewProj:ViewProjection;
   float4x4 World:World;    

//-------------
// tweaks
//-------------
   float OuterRadius;
   float InnerRadius;
   float4 TerrainSize;
   float4 TerrainTileSize;
   float TerrainHeight;

//-------------
// Textures
//-------------
   texture TerrainTexture <string Name = "";>;
   sampler TerrainSampler=sampler_state
      {
         Texture=<TerrainTexture>;
         MagFilter=Linear;
         MinFilter=Point;
         MipFilter=None;
         ADDRESSU=Clamp;
         ADDRESSV=Clamp;
      };

//-------------
// structs 
//-------------
   struct InPut
      {
         float4 Pos:POSITION;
         float2 Tex:TEXCOORD;
      };
   struct OutPut
      {
         float4 Pos:POSITION; 
         float2 WorldPos:TEXCOORD0;
      };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
      {
         OutPut OUT;
         float3 WorldPos=mul(IN.Pos,World);
         float4 NewUv=float4((WorldPos.xz/TerrainTileSize.xy)+TerrainTileSize.zw,0.0,0.0);
         float Height=tex2Dlod(TerrainSampler,NewUv).w;
         OUT.Pos=mul(float4(WorldPos.x,Height*(TerrainHeight/255),WorldPos.z,1.0),ViewProj);
         OUT.WorldPos=float2(WorldPos.x,WorldPos.z);
         return OUT;
      }

//--------------
// pixel shader
//--------------
   float4 PS1(OutPut IN) : COLOR
      {
         float2 Grid=frac(IN.WorldPos/TerrainSize.w);
         Grid=1.0-saturate((Grid*2.0)*((1.0-Grid)*2.0)*8.0);
         IN.WorldPos -=World[3].xz;
         float Radius1=saturate((64.0*TerrainSize.w*OuterRadius)-length(IN.WorldPos));
         float Radius2=saturate((64.0*TerrainSize.w*OuterRadius)-length(IN.WorldPos)-16.0);
         float Radius3=saturate((64.0*TerrainSize.w*OuterRadius*InnerRadius)-length(IN.WorldPos));
         float Radius4=saturate((64.0*TerrainSize.w*OuterRadius*InnerRadius)-length(IN.WorldPos)-16.0);
         Grid *=saturate(Radius2)*(1.0-saturate(Radius3));
         return Grid.x*0.25+Grid.y*0.25+saturate(Radius1-Radius2)*0.5+saturate(Radius3-Radius4)*0.5;
      }
   float4 PS2(OutPut IN) : COLOR
      {
         float2 Grid=frac(IN.WorldPos/TerrainSize.w);
         Grid=1.0-saturate((Grid*2.0)*((1.0-Grid)*2.0)*8.0);
         IN.WorldPos -=World[3].xz;
         float Radius1=saturate((64.0*TerrainSize.w*OuterRadius)-length(IN.WorldPos));
         float Radius2=saturate((64.0*TerrainSize.w*OuterRadius)-length(IN.WorldPos)-16.0);
         Grid *=saturate(Radius2);
         return Grid.x*0.25+Grid.y*0.25+saturate(Radius1-Radius2)*0.5;
      }

//--------------
// techniques   
//--------------
   technique Sculpt
      {
         pass p1
      {		
         vertexShader = compile vs_3_0 VS(); 
         pixelShader  = compile ps_3_0 PS1();
         ColorWriteEnable=7;
         AlphaBlendEnable=True;
         SrcBlend=One;
         DestBlend=One;
         AlphaTestEnable=false;
         zwriteenable=false;
         zenable=false;
         ZFunc=always;
      }
      }
   technique Paint
      {
         pass p1
      {		
         vertexShader = compile vs_3_0 VS(); 
         pixelShader  = compile ps_3_0 PS2();
         ColorWriteEnable=7;
         AlphaBlendEnable=True;
         SrcBlend=One;
         DestBlend=One;
         AlphaTestEnable=false;
         zwriteenable=false;
         zenable=false;
         ZFunc=always;
      }
      }